<?php $__env->startSection('content'); ?>
    <div class="dashboard-inner">
        <div class="row">
            <div class="col-md-12">
                <div class="text-end mb-3 d-flex flex-wrap justify-content-between gap-1">
                    <h3><?php echo e(__($pageTitle)); ?></h3>
                    <a href="<?php echo e(route('ticket.open')); ?>" class="btn btn--base btn--smd"><?php echo app('translator')->get('Open Support Ticket'); ?></a>
                </div>
                <div class="card">
                    <?php if(!blank($supports)): ?>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table--responsive--md">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('Subject'); ?></th>
                                        <th><?php echo app('translator')->get('Status'); ?></th>
                                        <th><?php echo app('translator')->get('Priority'); ?></th>
                                        <th><?php echo app('translator')->get('Last Reply'); ?></th>
                                        <th><?php echo app('translator')->get('Action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $supports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $support): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td> <a
                                                    href="<?php echo e(route('ticket.view', $support->ticket)); ?>"
                                                    class="fw-bold"> [<?php echo app('translator')->get('Ticket'); ?>#<?php echo e($support->ticket); ?>]
                                                    <?php echo e(__($support->subject)); ?> </a></td>
                                            <td>
                                                <?php echo $support->statusBadge; ?>
                                            </td>
                                            <td>
                                                <?php if($support->priority == 1): ?>
                                                    <span class="badge badge--dark"><?php echo app('translator')->get('Low'); ?></span>
                                                <?php elseif($support->priority == 2): ?>
                                                    <span class="badge badge--success"><?php echo app('translator')->get('Medium'); ?></span>
                                                <?php elseif($support->priority == 3): ?>
                                                    <span class="badge badge--primary"><?php echo app('translator')->get('High'); ?></span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php echo e(\Carbon\Carbon::parse($support->last_reply)->diffForHumans()); ?>

                                            </td>

                                            <td>
                                                <a href="<?php echo e(route('ticket.view', $support->ticket)); ?>"
                                                    class="btn btn--icon btn--primary">
                                                    <i class="fa fa-desktop"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="card-body text-center">
                        <h4 class="text--muted"><i class="far fa-frown"></i> <?php echo e(__($emptyMessage)); ?></h4>
                    </div>
                    <?php endif; ?>
                    <?php if($supports->hasPages()): ?>
                        <div class="card-footer">
                            <?php echo e($supports->links()); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sites/28b/6/61db25e12e/public_html/perview/income/core/resources/views/templates/invester/user/support/index.blade.php ENDPATH**/ ?>